<ulz-preview-listing :props='{{ json_encode( $props ) }}' inline-template>

    <div class="ulz-form">
        <div class="ulz-grid">
            <div class="ulz-col-6 ulz-col-lg-12">
                <div class="ulz-grid">
                    @php

                        $component->render([
                            'type' => 'select',
                            'id' => 'listing_cover_type',
                            'name' => esc_html__('Cover type', 'utillz-core'),
                            'v_model' => 'cover',
                            'value' => 'slider',
                            'options' => [
                                'none' => esc_html__('None', 'utillz-core'),
                                'image' => esc_html__('Image', 'utillz-core'),
                                'slider' => esc_html__('Slider', 'utillz-core'),
                                'author' => esc_html__('Author', 'utillz-core'),
                            ],
                            'allow_empty' => false,
                        ]);

                        $component->render([
                            'type' => 'select',
                            'id' => 'listing_cover_style',
                            'name' => esc_html__('Cover style', 'utillz-core'),
                            'v_model' => 'style',
                            'value' => 'landscape',
                            'options' => [
                                'landscape' => esc_html__('Landscape', 'utillz-core'),
                                'square' => esc_html__('Square', 'utillz-core'),
                                'portrait' => esc_html__('Portrait', 'utillz-core'),
                                'auto' => esc_html__('Automatic — Masonry', 'utillz-core'),
                            ],
                            'allow_empty' => false,
                            'dependency' => [
                                'id' => 'listing_cover_type',
                                'value' => [
                                    'slider',
                                    'image',
                                ],
                                'compare' => 'IN',
                            ],
                        ]);

                        $component->render([
                            'type' => 'select',
                            'id' => 'explore_type',
                            'name' => esc_html__('Explore page type', 'utillz-core'),
                            'options' => apply_filters('utillz/display/explore/type', [
                                'default' => esc_html__('Default', 'utillz-core'),
                            ]),
                            'allow_empty' => false,
                            'col' => 6
                        ]);

                        $component->render([
                            'type' => 'select',
                            'id' => 'explore_columns',
                            'name' => esc_html__('Explore columns', 'utillz-core'),
                            'value' => 3,
                            'options' => apply_filters('utillz/display/explore/columns', [
                                5 => esc_html__('20% — Small', 'utillz-core'),
                                4 => esc_html__('25% — Medium', 'utillz-core'),
                                3 => esc_html__('33% — Large', 'utillz-core'),
                                2 => esc_html__('50% — Supersize', 'utillz-core'),
                            ]),
                            'allow_empty' => false,
                            'col' => 6
                        ]);

                        $component->render([
                            'type' => 'checkbox',
                            'id' => 'display_listing_favorite',
                            'name' => esc_html__('Enable favorite?', 'utillz-core'),
                            'value' => true,
                            'v_model' => 'favorite',
                            'dependency' => [
                                'id' => 'listing_cover_type',
                                'value' => [
                                    'slider',
                                    'image',
                                ],
                                'compare' => 'IN',
                            ],
                        ]);

                        $component->render([
                            'type' => 'checkbox',
                            'id' => 'display_listing_review',
                            'name' => esc_html__('Enable review rating?', 'utillz-core'),
                            'value' => true,
                            'v_model' => 'review',
                        ]);

                        $component->render([
                            'type' => 'checkbox',
                            'id' => 'hide_listing_details',
                            'name' => esc_html__('Hide listing details?', 'utillz-core'),
                            'v_model' => 'hide_listing_details',
                        ]);

                        $component->render([
                            'type' => 'use_field',
                            'id' => 'display_listing_title',
                            'name' => esc_html__('Select title field', 'utillz-core'),
                            'v_model' => 'title',
                            'dependency' => [
                                'id' => 'hide_listing_details',
                                'value' => true,
                                'compare' => '!=',
                            ],
                            'col' => 6
                        ]);

                        $component->render([
                            'type' => 'use_field',
                            'id' => 'display_listing_tagline',
                            'name' => esc_html__('Select tagline field', 'utillz-core'),
                            'v_model' => 'tagline',
                            'dependency' => [
                                'id' => 'hide_listing_details',
                                'value' => true,
                                'compare' => '!=',
                            ],
                            'col' => 6
                        ]);

                        $component->render([
                            'type' => 'repeater',
                            'id' => 'display_listing_content',
                            'name' => esc_html__('Content', 'utillz-core'),
                            'v_model' => 'content',
                            'templates' => [

                                'label' => [
                                    'name' => esc_html__('Label', 'utillz-core'),
                                    'heading' => 'key',
                                    'fields' => [
                                        'format' => [
                                            'type' => 'text',
                                            'name' => esc_html__('Format', 'utillz-core'),
                                            'description' => esc_html__('{field} will be replaced with the field value. You can add additional text, example format: `{field} bedrooms`, will print `4 bedrooms`', 'utillz-core'),
                                            'value' => '{field}',
                                            'col' => 6,
                                        ],
                                        'key' => [
                                            'type' => 'text',
                                            'name' => esc_html__('Field id', 'utillz-core'),
                                            'description' => sprintf( esc_html__('Set the id of the field you want to use for rendering. You can use the custom fields or our pre-defined field ids %s', 'utillz-core'), '<a href="#" data-modal="field-ids"><strong>' . esc_html__( 'Check what field ids you can use', 'utillz-core' ) . '</strong></a>' ),
                                            'value' => 'price',
                                            'col' => 6,
                                        ],
                                        'icon' => [
                                            'type' => 'icon',
                                            'name' => esc_html__('Icon', 'utillz-core'),
                                        ],
                                        'render_format' => [
                                            'type' => 'select',
                                            'name' => esc_html__('Render format', 'utillz-core'),
                                            'options' => [
                                                'text' => esc_html__('Text', 'utillz-core'),
                                                'price' => esc_html__('Price', 'utillz-core'),
                                            ],
                                            'value' => 'text',
                                            'allow_empty' => false,
                                        ],
                                    ]
                                ],

                                'taxonomy' => [
                                    'name' => esc_html__('Taxonomy', 'utillz-core'),
                                    'heading' => 'key',
                                    'fields' => [
                                        'key' => [
                                            'type' => 'use_field',
                                            'name' => esc_html__('Select field', 'utillz-core'),
                                            'group' => 'taxonomy',
                                        ],
                                        'display_icons' => [
                                            'type' => 'checkbox',
                                            'name' => esc_html__('Display term icons?', 'utillz-core'),
                                        ],
                                    ]
                                ],

                            ],
                            'dependency' => [
                                'id' => 'hide_listing_details',
                                'value' => true,
                                'compare' => '!=',
                            ],
                        ]);

                        $component->render([
                            'type' => 'repeater',
                            'id' => 'display_listing_bottom',
                            'name' => esc_html__('Bottom labels', 'utillz-core'),
                            'v_model' => 'bottom_labels',
                            'templates' => [
                                'label' => [
                                    'name' => esc_html__('Label', 'utillz-core'),
                                    'heading' => 'key',
                                    'fields' => [
                                        'format' => [
                                            'type' => 'text',
                                            'name' => esc_html__('Format', 'utillz-core'),
                                            'description' => esc_html__('{field} will be replaced with the field value. You can add additional text, example format: `{field} bedrooms`, will print `4 bedrooms`', 'utillz-core'),
                                            'value' => '{field}',
                                            'col' => 6,
                                        ],
                                        'key' => [
                                            'type' => 'text',
                                            'name' => esc_html__('Field id', 'utillz-core'),
                                            'description' => sprintf( esc_html__('Set the id of the field you want to use for rendering. You can use the custom fields or our pre-defined field ids %s', 'utillz-core'), '<a href="#" data-modal="field-ids"><strong>' . esc_html__( 'Check what field ids you can use', 'utillz-core' ) . '</strong></a>' ),
                                            'value' => 'price',
                                            'col' => 6,
                                        ],
                                        'icon' => [
                                            'type' => 'icon',
                                            'name' => esc_html__('Icon', 'utillz-core'),
                                        ],
                                        'render_format' => [
                                            'type' => 'select',
                                            'name' => esc_html__('Render format', 'utillz-core'),
                                            'options' => [
                                                'text' => esc_html__('Text', 'utillz-core'),
                                                'price' => esc_html__('Price', 'utillz-core'),
                                            ],
                                            'value' => 'text',
                                            'allow_empty' => false,
                                        ],
                                    ]
                                ],
                            ],
                            'dependency' => [
                                'id' => 'hide_listing_details',
                                'value' => true,
                                'compare' => '!=',
                            ],
                        ]);

                    @endphp

                    <div class="ulz-form-group ulz-col-12 ulz-mt-3">
                        <button type="submit" class="ulz-button ulz--large">
                            <span>{{ $strings->save }}</span>
                        </button>
                    </div>

                </div>
            </div>
            <div class="ulz-col-6 ulz-col-lg-12">

                <div class="ulz-heading">
                    <label class="ulz-ellipsis ">
                        {{ $strings->preview }}
                    </label>
                </div>

                <div class="ulz-prv ulz-flex ulz-flex-column ulz-justify-center ulz-no-select">

                    <div class="ulz-prv-grid">
                        <template v-if="cover == 'image' || cover == 'slider'">
                            <div class="ulz-prv-image" :class="style">
                                {{-- <i class="ulz-prv-icon-image far fa-image"></i> --}}
                                <i class="ulz-prv-icon-image material-icons">image</i>
                                <i v-if="favorite" class="ulz-prv-icon-favorite fas fa-heart"></i>
                                <div v-if="cover == 'slider'" class="ulz-prv-slider">
                                    <i class="ulz-prv-slider-arrow-left fas fa-chevron-left"></i>
                                    <i class="ulz-prv-slider-arrow-right fas fa-chevron-right"></i>
                                </div>
                            </div>
                        </template>
                        <template v-if="cover == 'author'">
                            <div class="ulz-prv-author">
                                <div class="ulz-prv-author-image">
                                    <span></span>
                                </div>
                                <div class="ulz-prv-author-name">
                                    <span></span>
                                    <span></span>
                                </div>
                            </div>
                        </template>
                        <template v-if="!hide_listing_details">
                            <div class="ulz-prv-content">
                                <template v-if="! ( title || tagline || ( content && content !== '[]' ) || ( bottom_labels && bottom_labels !== '[]' ) )">
                                    <p>{{ esc_html__( 'Add any content', 'utillz-core' ) }}</p>
                                </template>
                                <div class="ulz-prv-heading">
                                    <div class="ulz-prv-title">
                                        <h3 v-if="title">{{ esc_html__( 'Listing title, siter amet conselen an actetur adipisced', 'utillz-core' ) }}</h3>
                                    </div>
                                    <div v-if="review" class="ulz-prv-review">
                                        <i class="fas fa-star ulz-mr-1"></i>
                                        <strong>5.00</strong>
                                    </div>
                                </div>
                                <p v-if="tagline">{{ esc_html__( 'Suspendisse feugiat ex non lacus maximus, ac efficitur nisi varius', 'utillz-core' ) }}</p>
                                <ul v-if="content && content !== '[]'" class="ulz-prv-labels ulz-prv-labels-dark ulz-mt-2">
                                    <li v-for="field in JSON.parse( content )"
                                        v-html="format_heading( field.fields.key, field.template.heading_text )">
                                        <!---->
                                    </li>
                                </ul>
                                <ul v-if="bottom_labels && bottom_labels !== '[]'" class="ulz-prv-labels ulz-prv-labels-dark ulz-mt-2">
                                    <li v-for="field in JSON.parse( bottom_labels )"
                                        v-html="format_heading( field.fields.key, field.template.heading_text )">
                                        <!---->
                                    </li>
                                </ul>
                            </div>
                        </template>

                    </div>

                </div>

            </div>
        </div>
    </div>
</ulz-preview-listing>
